// $Id: CCursor.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CCursor.hpp"
using Exponent::GUI::Windowing::CCursor;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CCursor, CCountedObject);

//	===========================================================================
CCursor CCursor::CCURSOR_ARROW(e_arrowCursor);

//	===========================================================================
CCursor CCursor::CCURSOR_HAND(e_handCursor);

//	===========================================================================
CCursor CCursor::CCURSOR_IBEAM(e_iBeamCursor);

//	===========================================================================
CCursor CCursor::CCURSOR_RESIZE(e_resizeCursor);

//	===========================================================================
CCursor CCursor::CCURSOR_HOUR(e_hourGlassCursor);

//	===========================================================================
CCursor CCursor::CCURSOR_UP_DOWN(e_upDownArrowCursor);

//	===========================================================================
CCursor CCursor::CCURSOR_LEFT_RIGHT(e_leftRightArrowCursor);

//	===========================================================================
CCursor CCursor::CCURSOR_SIZE_ALL(e_sizeAllCursor);

//	===========================================================================
CCursor::CCursor(EMouseCursor cursor)
{
	EXPONENT_CLASS_CONSTRUCTION(CCursor);
	NULL_POINTER(m_cursor);
	this->setCursor(cursor);
}

#ifdef WIN32
//	===========================================================================
CCursor::CCursor(HINSTANCE instance, const long resourceId)
{
	EXPONENT_CLASS_CONSTRUCTION(CCursor);
	this->setCursor(instance, resourceId);
}
#else
//	===========================================================================
CCursor::CCursor(const long resourceId)
{
	EXPONENT_CLASS_CONSTRUCTION(CCursor);
	NULL_POINTER(m_cursor);
	this->setCursor(resourceId);
}
#endif

//	===========================================================================
CCursor::~CCursor()
{
	EXPONENT_CLASS_DESTRUCTION(CCursor);
#ifdef WIN32
	if (m_cursor)
	{
		DestroyCursor(m_cursor);
		NULL_POINTER(m_cursor);
	}
#else
	// Make sure we set it back to the arrow
	this->setCursor(e_arrowCursor);
	if (m_cursor)
	{
		DisposeCCursor(m_cursor);
		NULL_POINTER(m_cursor);
	}
#endif
}

#ifdef WIN32
//	===========================================================================
HCURSOR CCursor::getCursor() const
{
	return m_cursor;
}

//	===========================================================================
void CCursor::setCursor(HINSTANCE instance, const long resourceId)
{
	m_cursor = LoadCursor(instance, MAKEINTRESOURCE(resourceId));
}
#else
//	===========================================================================
CCrsrHandle CCursor::getCursor() const
{
	return m_cursor;
}

//	===========================================================================
void CCursor::setCursor(const long resourceId)
{
	// Ive disabled this cos it pisses me off on the mac...
	NULL_POINTER(m_cursor);
	return;

	// Destroy the old one
	if (m_cursor)
	{
		DisposeCCursor(m_cursor);
		NULL_POINTER(m_cursor);
	}

	// Load the new cursor
	m_cursor = GetCCursor(resourceId);

	// Set the cursor if applicable
	if (m_cursor)
	{
		SetCCursor(m_cursor);
	}
}
#endif

//	===========================================================================
void CCursor::setCursor(EMouseCursor cursor)
{
#ifdef WIN32
	LPCTSTR cursorName = IDC_ARROW;
	switch(cursor)
	{
		case e_handCursor:				cursorName = IDC_HAND;		break;
		case e_hourGlassCursor:			cursorName = IDC_WAIT;		break;
		case e_upDownArrowCursor:		cursorName = IDC_SIZENS;	break;
		case e_leftRightArrowCursor:	cursorName = IDC_SIZEWE;	break;
		case e_iBeamCursor:				cursorName = IDC_IBEAM;		break;
		case e_resizeCursor:			cursorName = IDC_SIZENWSE;	break;
		case e_sizeAllCursor:			cursorName = IDC_SIZEALL;	break;
	}
	m_cursor = LoadCursor(NULL, cursorName);
#else
	m_cursorId = cursor;
	if (cursor == e_arrowCursor)
	{
		SetThemeCursor(kThemeArrowCursor);
	}
	return;
	switch(cursor)
	{
		case e_arrowCursor:				SetThemeCursor(kThemeArrowCursor);					break;
		case e_handCursor:				SetThemeCursor(kThemeOpenHandCursor);				break;
		case e_hourGlassCursor:			SetThemeCursor(kThemeWatchCursor);					break;
		case e_upDownArrowCursor:		SetThemeCursor(kThemeResizeUpDownCursor);			break;
		case e_leftRightArrowCursor:	SetThemeCursor(kThemeResizeLeftRightCursor);		break;
		case e_iBeamCursor:				SetThemeCursor(kThemeIBeamCursor);					break;
		case e_resizeCursor:			SetThemeCursor(kThemeArrowCursor);					break;
		case e_sizeAllCursor:			SetThemeCursor(kThemeArrowCursor);					break;	
	}
#endif
}

#ifdef WIN32
//	===========================================================================
void CCursor::setAnimatedCursor(HINSTANCE instance, const unsigned long resourceId)
{
	HRSRC resource = FindResource(instance, MAKEINTRESOURCE(resourceId), "ANICURSORS");
	DWORD size = SizeofResource(instance, resource);
	HGLOBAL global = LoadResource(instance, resource);
	LPBYTE data =(LPBYTE)LockResource(global);
	m_cursor = (HCURSOR)CreateIconFromResource(data, size, FALSE, 0x00030000);
}
#else
	// Mac equivalent not quite there yet!
#endif

//	===========================================================================
void CCursor::showCursor()
{
#ifdef WIN32
	ShowCursor(TRUE);
#else
	ShowCursor();
#endif
}

//	===========================================================================
void CCursor::hideCursor()
{
#ifdef WIN32
	ShowCursor(FALSE);
#else
	HideCursor();
#endif
}